#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Plik pochodzi z:
# http://www.gimp.org/tutorials/AutomatedJpgToXcf/
# 
# Sprawdzono pracuje poprawnie w:  
# gimp-2.8.6Portable32Partha i 2.8.6Portable64Partha , 
# 
# Ten program jest wolnym oprogramowaniem: możesz go rozprowadzać dalej 
# i / lub modyfikować
# Zgodnie z warunkami licencji GNU General Public opublikowane przez
# Free Software Foundation; wersji 3 tej Licencji lub
# (Do wyboru) którejś z późniejszych wersji.
#
# Ten program jest rozpowszechniany w nadziei, że będzie użyteczny,
# Ale BEZ JAKIEJKOLWIEK GWARANCJI; nawet bez gwarancji
# Handlowej lub przydatności do KONKRETNEGO CELU. Zobacz
# Licencja Publiczna GNU więcej szczegółów.
#
# Powinieneś otrzymać kopię GNU General Public License
# Wraz z tym programem. Jeśli nie, patrz <http://www.gnu.org/licenses/>
#
# Uwagi Autora:
# Ta przykładowa wtyczka jest bardzo prosta; tworzenie listy nazw plików, 
# prowadzenie przez te listy w pętli, otwarcie każdego pliku źródłowego i 
# z kolei  jego eksportowanie. Korzystając z tego przykładu będziemy mieć 
# możliwość jego wykorzystania jako modelu do budowy podobnych funkcji. 
# Przykładem podobnej funkcji może być konwersja katalogu plików XCF do 
# plików JPG, skalowanie oryginalnych plików jpg do mniejszego rozmiaru, itd.
#
# Podczas korzystania z niego GIMP przegląda system plików, prawdopodobnie  
# trzeba będzie wybrać "Inne", aby poruszać się, tam gdzie naprawdę chcemy. 
#
# W przypadku korzystania z automatycznej wtyczki zawsze dobrym pomysłem jest, 
# aby uruchomić go na KOPII swoich oryginalnych obrazów.
# Wtyczka jest przykładem, który ma na celu zilustrowanie automatyzacji 
# część procesu edycji.
#
# Więcej informacji w podanym powyżej linku do źródła.
#
# Uwaga: Nazwy katalogu zrodlowego i docelowego nie mogą zawierać 
# polskich znaków diakrytycznych !!!!

############################################################################
#
from gimpfu import *
import os
import re
#
def exampleJpgToXcf(srcPath, tgtPath):
    """Zarejestrowana funkcja exampleJpgToXcf, 
	konwersja wszystkich plików JPEG w katalogu źródłowym 
	na pliki XCF w katalogu docelowym. 
	Wymaga dwóch argumentów, ścieżki do katalogów źródłowego i docelowego. 
	Nie wymaga otwartego jakiegoś obrazu.
    """
    ###
    open_images, image_ids = pdb.gimp_image_list()
    if open_images > 0:
        pdb.gimp_message ("Zamknij otwarte obrazy i uruchom ponownie")
    else:
        # lista wszystkich plików w katalogach źródłowym i docelowym
        allFileList = os.listdir(srcPath)
        existingList = os.listdir(tgtPath)
        srcFileList = []
        tgtFileList = []
        xform = re.compile('\.jpg', re.IGNORECASE)
        # Znajdź wszystkie pliki z listy w formacie JPEG i utwórz nazwy plików XCF
        for fname in allFileList:
            fnameLow = fname.lower()
            if fnameLow.count('.jpg') > 0:
                srcFileList.append(fname)
                tgtFileList.append(xform.sub('.xcf',fname))
        # Słownik - nazw plików źródłowych i docelowych
        tgtFileDict = dict(zip(srcFileList, tgtFileList))
        # Pętla na jpeg, otwórz każdy i zapisz jako xcf
        for srcFile in srcFileList:
            # Nie nadpisuj istniejących, może być praca w toku
            if tgtFileDict[srcFile] not in existingList:
                # os.path.join wstawia odpowiedni rodzaj separatora pliku
                tgtFile = os.path.join(tgtPath, tgtFileDict[srcFile])
                srcFile = os.path.join(srcPath, srcFile)
                theImage = pdb.file_jpeg_load(srcFile, srcFile)
                theDrawable = theImage.active_drawable
                pdb.gimp_xcf_save(0, theImage, theDrawable, tgtFile, tgtFile)
                pdb.gimp_image_delete(theImage)
#
############################################################################
#
register (
    "exampleJpgToXcf",         # Nazwa rejestrowanej wtyczki w Przeglądarce procedur
    "Konwersja plików jpg na xcf ", # Opis okna wtyczki
    "Konwersja plików jpg na xcf ", # Nazwa Dokumentacyjna
    "Stephen Kiel Modified Zbyma72age",         # Author
    "Stephen Kiel",         #  Informacja o właścicielu prawach autorskich (Copyright) 
    "July 2013 Modified 07.2015",            # data utworzenia wtyczki
    "Konwersja JPG na XCF (Katalog)", # Etykieta
    "",     # Typ obrazu: z którym wtyczka może współpracować, nie wymaga otwarcia obrazu
    [
    ( PF_DIRNAME, "srcPath", "Katalog (źródłowy) oryginalnych JPG:", "" ),
    ( PF_DIRNAME, "tgtPath", "Katalog (docelowy) działających XCF:", "" ),
    ],
    [],
    exampleJpgToXcf,   #  Nazwa podana w def, wywoływana kodem wtyczki
    menu="<Image>/TEST"  # Lokalizacja w menu
    )   # Koniec register

main()